/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

public class LineFit {
    double intercept_;
    double slope_;
    boolean vertical_;

    public LineFit(double[] x, double[] y) {
        int length = x.length;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXSq = 0.0;
        double sumXY = 0.0;
        for (int i = 0; i < length; ++i) {
            sumX += x[i];
            sumY += y[i];
            sumXSq += x[i] * x[i];
            sumXY += x[i] * y[i];
        }
        double denominator = (double)length * sumXSq - sumX * sumX;
        if (denominator == 0.0) {
            this.vertical_ = true;
            this.intercept_ = sumX / (double)length;
        } else {
            this.slope_ = ((double)length * sumXY - sumX * sumY) / denominator;
            if (Double.isInfinite(this.slope_)) {
                this.vertical_ = true;
                this.intercept_ = sumX / (double)length;
            } else {
                this.intercept_ = -(sumX * sumXY - sumY * sumXSq) / denominator;
            }
        }
    }

    public double x(double y) {
        if (!this.vertical_) {
            return (y - this.intercept_) / this.slope_;
        }
        return this.intercept_;
    }

    public double y(double x) {
        if (!this.vertical_) {
            return this.slope_ * x + this.intercept_;
        }
        return Double.NaN;
    }
}

